/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.helptools;

import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;

public class FDARetriever {
    public static final String TRACE_MASK = "HFDARET";
    public static final String TRACE_MASKT = "HFDARETT";
    public static final String TRACE_MASKF = "HFDARETF";
    public static final String TRACE_MASKD = "HFDARETD";
    public static final String THIS_CLASS = "FDARetriever";
    private int _maxTextLength = Integer.MAX_VALUE;
    private HelpSet _helpSet;
    private String _title;
    private String _text;
    private Map _cache = new HashMap();
    public static final String ANYTHING = ".*?";
    public static final String TARGET = "(.*?)";
    public static final String PERIOD = "\\x2E";
    public static final String ANY_T = "[Tt]";
    public static final String ANY_I = "[Ii]";
    public static final String ANY_L = "[Ll]";
    public static final String ANY_E = "[Ee]";
    public static final String ANY_H = "[Hh]";
    public static final String ANY_P = "[Pp]";
    public static final String ANY_TITLE = "[Tt][Ii][Tt][Ll][Ee]";
    public static final String TITLE_TAG = "<[Tt][Ii][Tt][Ll][Ee]>";
    public static final String TITLE_TAG_END = "</[Tt][Ii][Tt][Ll][Ee]>";
    public static final String ANY_HEAD = "[Hh][12345]";
    public static final String HEAD_TAG = "<[Hh][12345]>";
    public static final String HEAD_TAG_END = "</[Hh][12345]>";
    public static final String P_TAG = "<[Pp]>";
    public static final String ANY_TAG = "<.+?>";
    public static final Pattern TITLE_PATTERN = Pattern.compile(".*?<[Tt][Ii][Tt][Ll][Ee]>(.*?)</[Tt][Ii][Tt][Ll][Ee]>.*?", 32);
    public static final Pattern TEXT_PATTERN = Pattern.compile(".*?<[Pp]>(.*?)<.+?>.*?", 32);
    public static final Pattern PERIOD_PATTERN = Pattern.compile("(.*?)\\x2E", 32);
    public static final Pattern LINE_END_PATTERN = Pattern.compile("\\r\\n");
    public static final Pattern BOLD_PATTERN = Pattern.compile("<[Bb]>");
    public static final Pattern BOLD_END_PATTERN = Pattern.compile("</[Bb]>");
    public static final Pattern I_PATTERN = Pattern.compile("<[Ii]>");
    public static final Pattern I_END_PATTERN = Pattern.compile("</[Ii]>");
    public static final Pattern ANCHOR_PATTERN = Pattern.compile("<[Aa] .*?>");
    public static final Pattern ANCHOR_END_PATTERN = Pattern.compile("</[Aa]>");
    public static final Pattern OTHER_TAG_PATTERN = Pattern.compile("<.+?>");
    public static final Pattern OTHER_END_TAG_PATTERN = Pattern.compile("</.+?>");
    public static final Pattern DL_PATTERN = Pattern.compile("<[Dd][LlTtDd]>");
    public static final Pattern DL_END_PATTERN = Pattern.compile("</[Dd][LlTtDd]>");
    public static final Pattern OL_PATTERN = Pattern.compile("<[OoUu][Ll]>");
    public static final Pattern OL_END_PATTERN = Pattern.compile("</[OoUu][Ll]>");
    public static final Pattern LI_PATTERN = Pattern.compile("<[Ll][Ii]>");
    public static final Pattern GLOBAL_PATTERN = Pattern.compile(".*?<[Tt][Ii][Tt][Ll][Ee]>(.*?)</[Tt][Ii][Tt][Ll][Ee]>.*?<[Pp]>(.*?)\\x2E(.*?)<.+?>.*?", 32);
    public static final Pattern ALT_GLOBAL_PATTERN = Pattern.compile(".*?<[Tt][Ii][Tt][Ll][Ee]>(.*?)</[Tt][Ii][Tt][Ll][Ee]>.*?<[Pp]>(.*?)<.+?>.*?", 32);

    public static void main(String[] args) throws Exception {
        FDARetriever retriever = new FDARetriever(args[0]);
        retriever.setMaxTextLength(155);
        retriever.testPrintAll();
    }

    public static void showUsage() {
        System.out.println("This class is used to retrieve help information from the HMC javahelp help sets.");
        System.out.println("It requires two arguments.  First, the URL for the helpset.  Second, the help");
        System.out.println("topic identifier.");
        System.out.println();
        System.out.println("The title and text for the help identifier are printed to System.out.");
        System.out.println();
        System.out.println("A sample invocation is:");
        System.out.println();
        System.out.println("   java com.ibm.hwmca.base.helpTools.FDARetriever.class");
        System.out.println("   jar:file:/D:/hmcHelpSets/zhelp.jar!/zhelp.hs");
        System.out.println("   com.ibm.hwmca.z.accountinfo.res.AccountInfoRes.AccountPanel.CustomerEdit");
    }

    public FDARetriever(String helpSetURL) throws MalformedURLException, IOException, HelpSetException {
        this._helpSet = new HelpSet(null, new URL(helpSetURL));
    }

    public void setMaxTextLength(int max) {
        this._maxTextLength = max;
    }

    public void setTopicId(String topicId) throws MalformedURLException, IOException {
        String[] topicInfo = (String[])this._cache.get(topicId);
        if (topicInfo == null) {
            URL url = FDARetriever.getURLFromId(topicId, this._helpSet);
            String topicHTML = FDARetriever.getTopicFromURL(url);
            topicInfo = FDARetriever.getTitleFirstSentenceAndRestOfFirstParagraph(topicHTML);
            this._cache.put(topicId, topicInfo);
        }
        this._title = topicInfo[0];
        String text = topicInfo[1] + topicInfo[2];
        this._text = text.length() > this._maxTextLength ? topicInfo[1] : text;
    }

    public String getTitle() {
        return this._title;
    }

    public String getText() {
        return this._text;
    }

    private String[] getTitleAndText(String topicId) throws MalformedURLException, IOException {
        String[] topicInfo = new String[2];
        URL url = FDARetriever.getURLFromId(topicId, this._helpSet);
        String topicHTML = FDARetriever.getTopicFromURL(url);
        topicInfo[0] = FDARetriever.getTitleFromTopic(topicHTML);
        topicInfo[1] = FDARetriever.getTextFromTopic(topicHTML);
        return topicInfo;
    }

    private void testPrintAll() throws MalformedURLException, IOException {
        javax.help.Map map = this._helpSet.getCombinedMap();
        Enumeration ids = map.getAllIDs();
        while (ids.hasMoreElements()) {
            String id = ((Map.ID)ids.nextElement()).getIDString();
            this.testPrintID(id);
        }
    }

    private void testPrintID(String id) throws MalformedURLException, IOException {
        this.setTopicId(id);
        System.out.println(id);
        System.out.println(this.getTitle());
        System.out.println(this.getText());
        System.out.println();
        System.out.println();
    }

    public static URL getURLFromId(String id, HelpSet helpSet) throws MalformedURLException {
        javax.help.Map map = helpSet.getCombinedMap();
        return map.getURLFromID(Map.ID.create((String)id, (HelpSet)helpSet));
    }

    public static String getTopicFromURL(URL url) throws MalformedURLException, IOException {
        InputStream content = (InputStream)url.getContent();
        InputStreamReader reader = new InputStreamReader(content);
        int size = content.available();
        char[] buffer = new char[size];
        for (int charsRead = 0; charsRead < size; charsRead += reader.read(buffer, charsRead, size - charsRead)) {
        }
        return new String(buffer);
    }

    public static String getTitleFromTopic(String topic) {
        Matcher matcher = TITLE_PATTERN.matcher(topic);
        matcher.lookingAt();
        return matcher.group(1).trim();
    }

    public static String getTextFromTopic(String topic) {
        Matcher matcher = TEXT_PATTERN.matcher(FDARetriever.removeBoldTags(topic));
        matcher.lookingAt();
        String result = FDARetriever.removeLineEnds(matcher.group(1).trim());
        if (!result.endsWith(".")) {
            result = result + ".";
        }
        return result;
    }

    public static String getFirstSentence(String text) {
        Matcher matcher = PERIOD_PATTERN.matcher(text);
        matcher.lookingAt();
        return matcher.group(1) + ".";
    }

    public static String removeLineEnds(String text) {
        Matcher matcher = LINE_END_PATTERN.matcher(text);
        return matcher.replaceAll(" ");
    }

    public static String removeBoldTags(String text) {
        Matcher matcher = BOLD_PATTERN.matcher(text);
        String result = matcher.replaceAll("\"");
        matcher = BOLD_END_PATTERN.matcher(result);
        return matcher.replaceAll("\"");
    }

    public static String removeITags(String text) {
        Matcher matcher = I_PATTERN.matcher(text);
        String result = matcher.replaceAll("\"");
        matcher = I_END_PATTERN.matcher(result);
        return matcher.replaceAll("\"");
    }

    public static String removeAnchorTags(String text) {
        Matcher matcher = ANCHOR_PATTERN.matcher(text);
        String result = matcher.replaceAll("\"");
        matcher = ANCHOR_END_PATTERN.matcher(result);
        return matcher.replaceAll("\"");
    }

    public static String removeOtherTags(String text) {
        Matcher matcher = OTHER_TAG_PATTERN.matcher(text);
        String result = matcher.replaceAll("");
        matcher = OTHER_END_TAG_PATTERN.matcher(result);
        return matcher.replaceAll("");
    }

    public static String removeDefinitionLists(String text) {
        Matcher matcher = DL_PATTERN.matcher(text);
        String result = matcher.replaceAll("\r\n");
        matcher = DL_END_PATTERN.matcher(result);
        return matcher.replaceAll("\r\n");
    }

    public static String removeOtherLists(String text) {
        Matcher matcher = OL_PATTERN.matcher(text);
        String result = matcher.replaceAll("\r\n");
        matcher = OL_END_PATTERN.matcher(result);
        result = matcher.replaceAll("\r\n");
        matcher = LI_PATTERN.matcher(result);
        return matcher.replaceAll("\r\n");
    }

    public static String[] getTitleFirstSentenceAndRestOfFirstParagraph(String text) {
        String[] result = new String[]{"", "", ""};
        try {
            String cleanText = FDARetriever.removeLineEnds(text);
            cleanText = FDARetriever.removeDefinitionLists(cleanText);
            cleanText = FDARetriever.removeOtherLists(cleanText);
            cleanText = FDARetriever.removeBoldTags(cleanText);
            cleanText = FDARetriever.removeITags(cleanText);
            cleanText = FDARetriever.removeAnchorTags(cleanText);
            Matcher matcher = GLOBAL_PATTERN.matcher(cleanText);
            matcher.lookingAt();
            try {
                result[0] = matcher.group(1).trim();
                result[1] = FDARetriever.removeOtherTags(matcher.group(2).trim());
                result[2] = FDARetriever.removeOtherTags(matcher.group(3).trim());
            }
            catch (Exception e) {
                matcher = ALT_GLOBAL_PATTERN.matcher(cleanText);
                matcher.lookingAt();
                result[0] = matcher.group(1).trim();
                result[1] = FDARetriever.removeOtherTags(matcher.group(2).trim());
            }
            if (!result[1].endsWith(".")) {
                result[1] = result[1] + ".";
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "FDARetriever.getTitleFirstSentenceAndRestOfFirstParagraph:  parse failed", e);
        }
        return result;
    }
}

